
import gurobipy as gp

# Create a new model
m = gp.Model("arcade_shooting")

# Create variables
deer = m.addVar(vtype=gp.GRB.INTEGER, name="deer")
bear = m.addVar(vtype=gp.GRB.INTEGER, name="bear")

# Set objective function
m.setObjective(4 * deer + 10 * bear, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(deer >= 5, "min_deer")
m.addConstr(bear >= 2, "min_bear")
m.addConstr(deer <= 10, "max_deer")
m.addConstr(bear <= 5, "max_bear")
m.addConstr(deer + bear <= 12, "total_shots")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of deer to shoot: {deer.x}")
    print(f"Optimal number of bear to shoot: {bear.x}")
    print(f"Maximum points: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

