
from gurobipy import *

# Create a new model
m = Model("Arcade_Shooting_Game")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="deer")
x2 = m.addVar(vtype=GRB.INTEGER, name="bears")

# Set the objective function
m.setObjective(4*x1 + 10*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 >= 5, "at_least_5_deer")
m.addConstr(x2 >= 2, "at_least_2_bears")
m.addConstr(x1 <= 10, "at_most_10_deer")
m.addConstr(x2 <= 5, "at_most_5_bears")
m.addConstr(x1 + x2 <= 12, "total_animals")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Deer: {x1.x}")
    print(f"Bears: {x2.x}")
    print(f"Total points: {4*x1.x + 10*x2.x}")
else:
    print("No optimal solution found")
