
import gurobipy as gp

# Create a new model
model = gp.Model("Arcade Shooting Game")

# Define variables
x1 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="deer")  # Number of deer shot
x2 = model.addVar(lb=0, ub=gp.GRB.INFINITY, name="bears")  # Number of bears shot

# Set objective function
model.setObjective(4*x1 + 10*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(x1 >= 5, name="min_deer")
model.addConstr(x2 >= 2, name="min_bears")
model.addConstr(x1 <= 10, name="max_deer")
model.addConstr(x2 <= 5, name="max_bears")
model.addConstr(x1 + x2 <= 12, name="total_animals")

# Solve the model
model.optimize()

# Print solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal strategy: Shoot {x1.varValue} deer and {x2.varValue} bears.")
else:
    print("The problem is infeasible.")
