
import gurobipy as gp

# Create a new model
m = gp.Model("clay_animals")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="mini_elephants") # Number of mini elephants
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="mini_lions") # Number of mini lions


# Set objective function
m.setObjective(50*x1 + 45*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 8*x2 <= 300, "clay_constraint") # Clay constraint
m.addConstr(x1 + x2 <= 33, "animal_constraint") # Animal constraint
m.addConstr(x1 >=0)
m.addConstr(x2 >=0)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of mini elephants: {x1.x}")
    print(f"Number of mini lions: {x2.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

