
from gurobipy import *

# Create a new model
m = Model("artist_optimization")

# Define the variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mini_elephants")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="mini_lions")

# Set the objective function
m.setObjective(50*x1 + 45*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 8*x2 <= 300, "clay_constraint")
m.addConstr(x1 + x2 <= 33, "time_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of mini elephants: {x1.x}")
    print(f"Number of mini lions: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found.")
