
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='mini_elephants', lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='mini_lions', lb=0, vtype=gurobi.GRB.INTEGER)

    # Set the objective function
    model.setObjective(50 * x1 + 45 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(10 * x1 + 8 * x2 <= 300, name='clay_constraint')
    model.addConstr(x1 + x2 <= 33, name='total_animals_constraint')

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: mini elephants = {x1.varValue}, mini lions = {x2.varValue}")
    else:
        print("The model is infeasible")

solve_optimization_problem()
