
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
x1 = m.addVar(lb=0, name="Delta_Investment")  # Dollars invested in Delta
x2 = m.addVar(lb=0, name="Omega_Investment")  # Dollars invested in Omega


# Set objective function: Maximize total profit
m.setObjective(0.8 * x1 + 1.2 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100000, "Total_Budget")  # Total budget constraint
m.addConstr(x1 >= 0.25 * (x1 + x2), "Delta_Percentage")  # Minimum investment in Delta
m.addConstr(x2 >= 10000, "Omega_Minimum")  # Minimum investment in Omega


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Invest ${x1.x:.2f} in Delta")
    print(f"Invest ${x2.x:.2f} in Omega")
    print(f"Total Profit: ${m.objVal:.2f}")

