
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Add variables
x1 = m.addVar(lb=0, name="Delta_Investment")
x2 = m.addVar(lb=0, name="Omega_Investment")

# Set the objective function
m.setObjective(0.80*x1 + 1.20*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100000, "Budget_Constraint")
m.addConstr(x1 >= 0.25*(x1 + x2), "Delta_Minimum_Constraint")
m.addConstr(x2 >= 10000, "Omega_Minimum_Constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Delta Investment: {x1.x}")
    print(f"Omega Investment: {x2.x}")
    print(f"Total Profit: {m.objVal}")
else:
    print("No optimal solution found")
