
import gurobipy as gp

def solve_investment_problem():
    # Create a new model
    model = gp.Model("investment_problem")

    # Define variables
    x1 = model.addVar(name="Delta_Investment", lb=0)
    x2 = model.addVar(name="Omega_Investment", lb=0)

    # Objective function: Maximize 0.8*x1 + 1.2*x2
    model.setObjective(0.8*x1 + 1.2*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 100000, name="Total_Budget")
    model.addConstr(x1 >= 0.25*(x1 + x2), name="Min_Delta_Investment")
    model.addConstr(x2 >= 10000, name="Min_Omega_Investment")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal Investment in Delta: ${x1.varValue:.2f}")
        print(f"Optimal Investment in Omega: ${x2.varValue:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_investment_problem()
