
import gurobipy as gp

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="small_smoothies") # Number of small smoothies
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="large_smoothies") # Number of large smoothies


# Set objective function
m.setObjective(3*x1 + 5*x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 <= 20, "ice_cream_constraint")
m.addConstr(x1 + 2*x2 <= 18, "peanut_butter_constraint")
m.addConstr(x1 >= 0, "small_smoothies_nonnegative")
m.addConstr(x2 >= 0, "large_smoothies_nonnegative")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small smoothies: {x1.x}")
    print(f"Number of large smoothies: {x2.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

