
from gurobipy import *

# Create a new model
m = Model("Smoothie_Problem")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="small_smoothies")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="large_smoothies")

# Set the objective function
m.setObjective(3*x1 + 5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1 + 3*x2 <= 20, "ice_cream_constraint")
m.addConstr(x1 + 2*x2 <= 18, "peanut_butter_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.x}, x2 = {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
