
import gurobi

def solve_smoothie_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="small_smoothies", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="large_smoothies", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: maximize 3*x1 + 5*x2
    model.setObjective(3*x1 + 5*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(2*x1 + 3*x2 <= 20, name="ice_cream_constraint")
    model.addConstr(x1 + 2*x2 <= 18, name="peanut_butter_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("The model is infeasible")

solve_smoothie_problem()
