
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Pumpkin Transportation")

# Create variables
trucks = m.addVar(vtype=GRB.INTEGER, name="trucks")
vans = m.addVar(vtype=GRB.INTEGER, name="vans")

# Set objective function
m.setObjective(40 * trucks + 25 * vans, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15 * trucks + 10 * vans <= 300, "Budget")
m.addConstr(trucks <= vans, "Pollution")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"Number of trucks: {trucks.x}")
    print(f"Number of vans: {vans.x}")
    print(f"Number of pumpkins transported: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

