
import gurobipy as gp

def solve_pumpkin_transportation_problem():
    # Create a new model
    model = gp.Model("pumpkin_transportation")

    # Define variables
    x1 = model.addVar(name="trucks", vtype=gp.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="vans", vtype=gp.GRB.INTEGER, lb=0)

    # Objective function: Maximize 40*x1 + 25*x2
    model.setObjective(40*x1 + 25*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15*x1 + 10*x2 <= 300, name="budget_constraint")
    model.addConstr(x1 <= x2, name="pollution_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: trucks = {x1.varValue}, vans = {x2.varValue}")
        print(f"Maximum pumpkins transported: {40*x1.varValue + 25*x2.varValue}")
    else:
        print("The problem is infeasible")

solve_pumpkin_transportation_problem()
