
import gurobipy as gp

# Create a new model
model = gp.Model("TailorShop")

# Create variables
pants = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pants")
shorts = model.addVar(vtype=gp.GRB.CONTINUOUS, name="shorts")

# Set objective function
model.setObjective(5 * pants + 7 * shorts, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(0.5 * pants + 0.1 * shorts <= 60, "Measuring")
model.addConstr(0.2 * pants + 0.5 * shorts <= 80, "Cutting")
model.addConstr(0.7 * pants + 0.6 * shorts <= 75, "Sewing")
model.addConstr(pants >=0)
model.addConstr(shorts >=0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${model.objVal:.2f}")
    print(f"Number of pants: {pants.x:.2f}")
    print(f"Number of shorts: {shorts.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

