
from gurobipy import *

# Create a new model
m = Model("Tailor_Shop_Optimization")

# Define variables
x1 = m.addVar(name="pants", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="shorts", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x1 + 0.1*x2 <= 60, name="measuring_team")
m.addConstr(0.2*x1 + 0.5*x2 <= 80, name="cutting_team")
m.addConstr(0.7*x1 + 0.6*x2 <= 75, name="sewing_team")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of pants: {x1.x}")
    print(f"Number of shorts: {x2.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
