
import gurobipy as gp

# Create a new model
model = gp.Model("TailorShop")

# Define the variables
x1 = model.addVar(name="pants", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="shorts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(0.5*x1 + 0.1*x2 <= 60, name="measuring")
model.addConstr(0.2*x1 + 0.5*x2 <= 80, name="cutting")
model.addConstr(0.7*x1 + 0.6*x2 <= 75, name="sewing")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Pants: {x1.varValue}")
    print(f"Shorts: {x2.varValue}")
    print(f"Max Profit: {model.objVal}")
else:
    print("No optimal solution found")
