
import gurobipy as gp

# Create a new model
model = gp.Model("Pizza Optimization")

# Create variables
cheese_pizza = model.addVar(vtype=gp.GRB.CONTINUOUS, name="cheese_pizza")
pepperoni_pizza = model.addVar(vtype=gp.GRB.CONTINUOUS, name="pepperoni_pizza")


# Set objective function
model.setObjective(7 * cheese_pizza + 9 * pepperoni_pizza, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(30 * cheese_pizza + 40 * pepperoni_pizza <= 3000, "flour_constraint")
model.addConstr(50 * cheese_pizza + 20 * pepperoni_pizza <= 4000, "cheese_constraint")
model.addConstr(40 * cheese_pizza + 30 * pepperoni_pizza <= 5000, "sauce_constraint")
model.addConstr(cheese_pizza >=0)
model.addConstr(pepperoni_pizza >=0)


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of Cheese Pizzas: {cheese_pizza.x}")
    print(f"Number of Pepperoni Pizzas: {pepperoni_pizza.x}")
    print(f"Maximum Profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

