
from gurobipy import *

# Create a new model
m = Model("Pizza_Profit")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="cheese_pizzas")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="pepperoni_pizzas")

# Set the objective function
m.setObjective(7*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 40*x2 <= 3000, "flour_constraint")
m.addConstr(50*x1 + 20*x2 <= 4000, "cheese_constraint")
m.addConstr(40*x1 + 30*x2 <= 5000, "sauce_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of cheese pizzas: {x1.x}")
    print(f"Number of pepperoni pizzas: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
