
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_problem")

# Define variables
x1 = m.addVar(name="cheese_pizzas", lb=0, vtype=gp.GRB.INTEGER)  # Number of cheese pizzas
x2 = m.addVar(name="pepperoni_pizzas", lb=0, vtype=gp.GRB.INTEGER)  # Number of pepperoni pizzas

# Objective function: Maximize profit
m.setObjective(7*x1 + 9*x2, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(30*x1 + 40*x2 <= 3000, name="flour_constraint")  # Flour constraint
m.addConstr(50*x1 + 20*x2 <= 4000, name="cheese_constraint")  # Cheese constraint
m.addConstr(40*x1 + 30*x2 <= 5000, name="sauce_constraint")  # Sauce constraint

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal number of cheese pizzas: {x1.varValue}")
    print(f"Optimal number of pepperoni pizzas: {x2.varValue}")
    print(f"Maximum profit: ${m.objVal:.2f}")
else:
    print("The model is infeasible.")
