
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Milk Transportation")

# Create variables
rail = m.addVar(vtype=GRB.INTEGER, name="rail")
truck = m.addVar(vtype=GRB.INTEGER, name="truck")

# Set objective function
m.setObjective(400 * rail + 200 * truck, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100 * rail + 85 * truck <= 3000, "budget")
m.addConstr(rail <= truck, "rail_limit")
m.addConstr(rail >= 0, "rail_nonneg")
m.addConstr(truck >= 0, "truck_nonneg")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Rail shipments: {rail.x}")
    print(f"  Truck shipments: {truck.x}")
    print(f"  Total milk transported: {400 * rail.x + 200 * truck.x} litres")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

