
from gurobipy import *

# Create a new model
m = Model("Milk_Transport")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="rail_shipments")
x2 = m.addVar(vtype=GRB.INTEGER, name="truck_shipments")

# Set objective function
m.setObjective(400*x1 + 200*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100*x1 + 85*x2 <= 3000, "budget_constraint")
m.addConstr(x1 <= x2, "shipment_ratio_constraint")
m.addConstr(x1 >= 0, "non_neg_rail")
m.addConstr(x2 >= 0, "non_neg_truck")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Rail Shipments: {x1.x}")
    print(f"Truck Shipments: {x2.x}")
    print(f"Total Milk Transported: {400*x1.x + 200*x2.x} litres")
else:
    print("No optimal solution found.")
