
import gurobipy as gp

def solve_milk_transportation_problem():
    # Create a new model
    model = gp.Model("MilkTransportation")

    # Define variables
    x1 = model.addVar(name="rail_shipments", vtype=gp.GRB.INTEGER, lb=0)
    x2 = model.addVar(name="truck_shipments", vtype=gp.GRB.INTEGER, lb=0)

    # Objective function: Maximize 400*x1 + 200*x2
    model.setObjective(400*x1 + 200*x2, gp.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(100*x1 + 85*x2 <= 3000, name="budget_constraint")
    model.addConstr(x1 <= x2, name="rail_truck_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gp.GRB.OPTIMAL:
        print(f"Optimal solution: rail shipments = {x1.varValue}, truck shipments = {x2.varValue}")
    else:
        print("No optimal solution found.")

solve_milk_transportation_problem()
