
import gurobipy as gp

# Create a new model
m = gp.Model("Trail Mix Optimization")

# Create variables
x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="trail_mix_A") # Bags of trail mix A
x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="trail_mix_B") # Bags of trail mix B


# Set objective function
m.setObjective(5*x1 + 8*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 >= 20, "almonds_constraint")
m.addConstr(1*x1 + 3*x2 >= 15, "chocolate_chips_constraint")
m.addConstr(x1 >= 0, "non_negativity_A")
m.addConstr(x2 >= 0, "non_negativity_B")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: ${m.objVal}")
    print(f"Bags of Trail Mix A: {x1.x}")
    print(f"Bags of Trail Mix B: {x2.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

