
from gurobipy import *

# Create a new model
m = Model("Trail_Mix_Optimization")

# Define variables
x1 = m.addVar(name="Trail_Mix_A", vtype=GRB.CONTINUOUS, lb=0)
x2 = m.addVar(name="Trail_Mix_B", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function
m.setObjective(5*x1 + 8*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x1 + 2*x2 >= 20, name="Almonds_Constraint")
m.addConstr(x1 + 3*x2 >= 15, name="Chocolate_Chips_Constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of bags of Trail Mix A: {x1.x}")
    print(f"Number of bags of Trail Mix B: {x2.x}")
    print(f"Total cost: ${5*x1.x + 8*x2.x:.2f}")
else:
    print("No optimal solution found")
