
import gurobi

def solve_trail_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="trail_mix_A", lb=0, vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="trail_mix_B", lb=0, vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 5*x1 + 8*x2
    model.setObjective(5*x1 + 8*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(2*x1 + 2*x2 >= 20, name="almonds_constraint")
    model.addConstr(x1 + 3*x2 >= 15, name="chocolate_chips_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
        print(f"Minimum cost: {model.objVal}")
    else:
        print("The model is infeasible")

solve_trail_mix_problem()
