
import gurobipy as gp

# Create a new model
m = gp.Model("Investment_Problem")

# Create variables
fertilizer = m.addVar(name="fertilizer")
pesticide = m.addVar(name="pesticide")

# Set objective function
m.setObjective(0.14 * fertilizer + 0.15 * pesticide, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(fertilizer + pesticide <= 5000, "Total_Investment")
m.addConstr(fertilizer >= 0.5 * (fertilizer + pesticide), "Fertilizer_Proportion")
m.addConstr(pesticide >= 1000, "Minimum_Pesticide")
m.addConstr(fertilizer >=0, "NonNegative_Fertilizer")
m.addConstr(pesticide >=0, "NonNegative_Pesticide")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Invest ${fertilizer.x:.2f} in fertilizer company")
    print(f"Invest ${pesticide.x:.2f} in pesticide company")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

