
from gurobipy import *

# Create a new model
m = Model("Investment_Optimization")

# Define variables
x1 = m.addVar(name="Fertilizer_Investment", lb=0)
x2 = m.addVar(name="Pesticide_Investment", lb=0)

# Set the objective function
m.setObjective(0.14*x1 + 0.15*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 5000, name="Total_Investment")
m.addConstr(x1 >= 0.5*(x1 + x2), name="Fertilizer_Percentage")
m.addConstr(x2 >= 1000, name="Pesticide_Minimum")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Amount invested in Fertilizer Company: {x1.x}")
    print(f"Amount invested in Pesticide Company: {x2.x}")
else:
    print("No optimal solution found.")

