
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="fertilizer_company", lb=0)
    x2 = model.addVar(name="pesticide_company", lb=0)

    # Objective function: Maximize 0.14*x1 + 0.15*x2
    model.setObjective(0.14*x1 + 0.15*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x1 + x2 <= 5000, name="total_investment")
    model.addConstr(x1 >= 0.5 * (x1 + x2), name="fertilizer_proportion")
    model.addConstr(x2 >= 1000, name="pesticide_minimum")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Invest in fertilizer company: ${x1.x:.2f}")
        print(f"Invest in pesticide company: ${x2.x:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
