
import gurobipy as gp

# Create a new model
model = gp.Model("SupplementProblem")

# Create variables
chewable = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chewable")
regular = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="regular")


# Set objective function
model.setObjective(0.5 * chewable + 0.4 * regular, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(2 * chewable + 3 * regular >= 30, "VitaminA")
model.addConstr(3 * chewable + 2 * regular >= 20, "VitaminC")
model.addConstr(3 * chewable + 4 * regular >= 40, "VitaminD")
model.addConstr(2 * chewable + 4 * regular >= 30, "VitaminE")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Chewable pills: {chewable.x:.2f}")
    print(f"Regular pills: {regular.x:.2f}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print(f"Optimization ended with status {model.status}")

