
import gurobipy as gp

# Create a new model
model = gp.Model("Vitamin_Supplement")

# Define the variables
x1 = model.addVar(name="chewable_pills", lb=0, vtype=gp.GRB.INTEGER)
x2 = model.addVar(name="regular_pills", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
model.setObjective(0.50*x1 + 0.40*x2, gp.GRB.MINIMIZE)

# Add the constraints
model.addConstr(2*x1 + 3*x2 >= 30, name="vitamin_A")
model.addConstr(3*x1 + 2*x2 >= 20, name="vitamin_C")
model.addConstr(3*x1 + 4*x2 >= 40, name="vitamin_D")
model.addConstr(2*x1 + 4*x2 >= 30, name="vitamin_E")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Number of chewable pills: {x1.varValue}")
    print(f"Number of regular pills: {x2.varValue}")
    print(f"Total cost: {model.objVal}")
else:
    print("No optimal solution found.")
