
from gurobipy import Model, GRB

# Create a new model
model = Model("Drug Mixture")

# Create variables
x1 = model.addVar(lb=0, name="drug_A")  # amount of drug A (mg)
x2 = model.addVar(lb=0, name="drug_B")  # amount of drug B (mg)


# Set objective function
model.setObjective(0.5 * x1 + 0.3 * x2, GRB.MINIMIZE)

# Add constraints
model.addConstr(3 * x1 + 2 * x2 >= 5, "pain_killer_req")
model.addConstr(2.5 * x1 + 3.5 * x2 >= 12, "fever_reliever_req")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${model.objVal:.2f}")
    print(f"Amount of drug A: {x1.x:.2f} mg")
    print(f"Amount of drug B: {x2.x:.2f} mg")
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

