
from gurobipy import *

# Create a new model
m = Model("Mixture_Optimization")

# Define variables
x1 = m.addVar(name="drug_a", lb=0)
x2 = m.addVar(name="drug_b", lb=0)

# Set the objective function
m.setObjective(0.5*x1 + 0.3*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 2*x2 >= 5, name="pain_killer_constraint")
m.addConstr(2.5*x1 + 3.5*x2 >= 12, name="fever_reliever_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Amount of Drug A: {x1.x} mg")
    print(f"Amount of Drug B: {x2.x} mg")
    print(f"Total Cost: ${0.5*x1.x + 0.3*x2.x:.2f}")
else:
    print("No optimal solution found")
