
import gurobi

def solve_lp():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(lb=0, name="x1")  # amount of drug A
    x2 = model.addVar(lb=0, name="x2")  # amount of drug B

    # Define the objective function
    model.setObjective(0.50 * x1 + 0.30 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 2 * x2 >= 5, name="pain_killer_constraint")
    model.addConstr(2.5 * x1 + 3.5 * x2 >= 12, name="fever_reliever_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Amount of drug A: {x1.varValue} mg")
        print(f"Amount of drug B: {x2.varValue} mg")
        print(f"Total cost: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_lp()
