
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pill_optimization")

# Create variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="blue_pill") # Number of blue pills
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="red_pill") # Number of red pills

# Set objective function
m.setObjective(1*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 >= 100, "blood_pressure_req")
m.addConstr(3*x1 + 7*x2 >= 70, "diabetes_req")
m.addConstr(x1 >= 0, "blue_pill_nonneg")
m.addConstr(x2 >= 0, "red_pill_nonneg")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal cost: ${m.objVal:.2f}")
    print(f"Number of blue pills: {x1.x:.2f}")
    print(f"Number of red pills: {x2.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

