
from gurobipy import *

# Create a new model
m = Model("Blood_Pressure_Diabetes")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="blue_pills")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="red_pills")

# Set the objective function
m.setObjective(1*x1 + 2*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(10*x1 + 5*x2 >= 100, "blood_pressure")
m.addConstr(3*x1 + 7*x2 >= 70, "diabetes")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Blue pills: {x1.x}")
    print(f"Red pills: {x2.x}")
    print(f"Total cost: ${1*x1.x + 2*x2.x:.2f}")
else:
    print("No optimal solution found")
