
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="blue_pills", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="red_pills", lb=0, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(1*x1 + 2*x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10*x1 + 5*x2 >= 100, name="blood_pressure_constraint")
    model.addConstr(3*x1 + 7*x2 >= 70, name="diabetes_constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Number of blue pills: {x1.varValue}")
        print(f"Number of red pills: {x2.varValue}")
        print(f"Total cost: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
