
import gurobipy as gp

# Create a new model
model = gp.Model("Candy Production")

# Create decision variables
lemon_candy = model.addVar(vtype=gp.GRB.INTEGER, name="lemon_candy")
cherry_candy = model.addVar(vtype=gp.GRB.INTEGER, name="cherry_candy")

# Set objective function
model.setObjective(5 * lemon_candy + 7 * cherry_candy, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * lemon_candy + 25 * cherry_candy <= 3000, "time_constraint")
model.addConstr(lemon_candy <= 100, "lemon_limit")
model.addConstr(cherry_candy <= 80, "cherry_limit")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of lemon candy packets: {lemon_candy.x}")
    print(f"Number of cherry candy packets: {cherry_candy.x}")
    print(f"Maximum profit: ${model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

