
from gurobipy import *

# Create a model
m = Model("Candy Optimization")

# Define variables
x1 = m.addVar(lb=0, name="lemon_candy_packets")
x2 = m.addVar(lb=0, name="cherry_candy_packets")

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x1 + 25*x2 <= 3000, "time_constraint")
m.addConstr(x1 <= 100, "max_lemon_candy")
m.addConstr(x2 <= 80, "max_cherry_candy")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Lemon candy packets: {x1.x}")
    print(f"Cherry candy packets: {x2.x}")
    print(f"Maximum profit: ${5*x1.x + 7*x2.x}")
else:
    print("No optimal solution found")
