
import gurobipy as gp

# Create a new model
model = gp.Model("Candy_Production")

# Define variables
x1 = model.addVar(name="lemon_candy", lb=0, ub=100, vtype=gp.GRB.INTEGER)  # Number of lemon candy packets
x2 = model.addVar(name="cherry_candy", lb=0, ub=80, vtype=gp.GRB.INTEGER)  # Number of cherry candy packets

# Objective function: Maximize profit
model.setObjective(5 * x1 + 7 * x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(20 * x1 + 25 * x2 <= 3000, name="time_constraint")  # Time constraint
model.addConstr(x1 <= 100, name="lemon_limit")  # Lemon candy limit
model.addConstr(x2 <= 80, name="cherry_limit")  # Cherry candy limit

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: Lemon candy packets = {x1.varValue}, Cherry candy packets = {x2.varValue}")
    print(f"Maximum profit: ${5 * x1.varValue + 7 * x2.varValue}")
else:
    print("No optimal solution found.")
