
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("toy_production")

    # Create variables
    trains = m.addVar(vtype='C', name='trains')  # Number of trains
    planes = m.addVar(vtype='C', name='planes')  # Number of planes


    # Set objective function
    m.setObjective(7 * trains + 9 * planes, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(30 * trains + 40 * planes <= 5000, "building_time")  # Building time constraint
    m.addConstr(40 * trains + 50 * planes <= 6000, "painting_time") # Painting time constraint
    
    # Non-negativity constraints are added implicitly by setting vtype='C' (continuous)
    # but we can add them explicitly for clarity:
    m.addConstr(trains >= 0)
    m.addConstr(planes >= 0)


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal:.2f}")
        print(f"Number of trains to produce: {trains.x:.2f}")
        print(f"Number of planes to produce: {planes.x:.2f}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
