
from gurobipy import *

# Create a new model
m = Model("Toy_Company_Profit")

# Define the variables
x1 = m.addVar(vtype=GRB.INTEGER, name="model_trains")
x2 = m.addVar(vtype=GRB.INTEGER, name="model_planes")

# Set the objective function
m.setObjective(7*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x1 + 40*x2 <= 5000, "building_time")
m.addConstr(40*x1 + 50*x2 <= 6000, "painting_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Model Trains: {x1.x}")
    print(f"Model Planes: {x2.x}")
    print(f"Maximum Profit: ${7*x1.x + 9*x2.x}")
else:
    print("No optimal solution found")
