
import gurobi

def solve_model_trains_and_planes():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="model_trains", lb=0, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="model_planes", lb=0, ub=gurobi.GRB.INFINITY)

    # Define objective function
    model.setObjective(7 * x1 + 9 * x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(30 * x1 + 40 * x2 <= 5000, name="building_time")
    model.addConstr(40 * x1 + 50 * x2 <= 6000, name="painting_time")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: {x1.varName} = {x1.x}, {x2.varName} = {x2.x}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_model_trains_and_planes()
