
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("circuit_board_production")

# Create variables
x1 = m.addVar(vtype=GRB.INTEGER, name="small_boards") # number of small circuit boards
x2 = m.addVar(vtype=GRB.INTEGER, name="large_boards") # number of large circuit boards


# Set objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 600, "drilling_constraint")
m.addConstr(15*x1 + 18*x2 <= 600, "printing_constraint")
m.addConstr(x1 >=0)
m.addConstr(x2 >=0)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of small circuit boards: {x1.x}")
    print(f"Number of large circuit boards: {x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

