
from gurobipy import *

# Create a model
m = Model("Circuit_Boards")

# Define variables
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="small_circuit_boards")
x2 = m.addVar(lb=0, vtype=GRB.INTEGER, name="large_circuit_boards")

# Set the objective function
m.setObjective(5*x1 + 7*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x1 + 15*x2 <= 600, "drilling_machine")
m.addConstr(15*x1 + 18*x2 <= 600, "printing_machine")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of small circuit boards: {x1.x}")
    print(f"Number of large circuit boards: {x2.x}")
    print(f"Total profit: {m.objVal}")
else:
    print("No optimal solution found")
