
import gurobipy as gp

# Create a new model
model = gp.Model("circuit_boards")

# Define variables
x1 = model.addVar(name="small_circuit_boards", lb=0, vtype=gp.GRB.CONTINUOUS)
x2 = model.addVar(name="large_circuit_boards", lb=0, vtype=gp.GRB.CONTINUOUS)

# Set objective function
model.setObjective(5*x1 + 7*x2, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x1 + 15*x2 <= 600, name="drilling_machine_time")
model.addConstr(15*x1 + 18*x2 <= 600, name="printing_machine_time")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x1 = {x1.varValue}, x2 = {x2.varValue}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")
