
import gurobipy as gp

# Create a new model
m = gp.Model("fruit_packages")

# Create variables
mango_lovers = m.addVar(vtype=gp.GRB.CONTINUOUS, name="mango_lovers")  # x1
regular = m.addVar(vtype=gp.GRB.CONTINUOUS, name="regular")  # x2


# Set objective function
m.setObjective(5 * mango_lovers + 6.5 * regular, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(4 * mango_lovers + 3 * regular <= 30, "lemons_constraint")
m.addConstr(8 * mango_lovers + 5 * regular <= 40, "mangos_constraint")
m.addConstr(10 * regular <= 50, "pears_constraint")
m.addConstr(mango_lovers >=0)
m.addConstr(regular >= 0)


# Optimize model
m.optimize()

if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found: Mango-lovers packages = {mango_lovers.x}, Regular packages = {regular.x}")
    print(f"Optimal profit: {m.objVal} euros")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

