
from gurobipy import *

# Create a new model
m = Model("Fruit Store Optimization")

# Define variables
x1 = m.addVar(lb=0, name="mango_lovers_packages")
x2 = m.addVar(lb=0, name="regular_packages")

# Set the objective function
m.setObjective(5*x1 + 6.5*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x1 + 3*x2 <= 30, "lemon_constraint")
m.addConstr(8*x1 + 5*x2 <= 40, "mango_constraint")
m.addConstr(10*x2 <= 50, "pear_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of mango-lovers packages: {x1.x}")
    print(f"Number of regular packages: {x2.x}")
    print(f"Max Profit: {m.objVal}")
else:
    print("No optimal solution found")
