
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="mango-lovers_packages", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    x2 = model.addVar(name="regular_packages", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(5 * x1 + 6.5 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4 * x1 + 3 * x2 <= 30, name="lemons_constraint")
    model.addConstr(8 * x1 + 5 * x2 <= 40, name="mangos_constraint")
    model.addConstr(10 * x2 <= 50, name="pears_constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Mango-lovers packages: {x1.varValue}")
        print(f"Regular packages: {x2.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
