
import gurobipy as gp

# Create a new model
m = gp.Model("luggage_production")

# Create variables
carry_on = m.addVar(vtype=gp.GRB.CONTINUOUS, name="carry_on")  # allows for fractional suitcases for now
large = m.addVar(vtype=gp.GRB.CONTINUOUS, name="large")

# Set objective function
m.setObjective(100 * carry_on + 150 * large, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(carry_on <= 15, "carry_on_production_limit")
m.addConstr(large <= 20, "large_production_limit")
m.addConstr(carry_on + large <= 25, "sewing_machine_limit")
m.addConstr(carry_on >= 0, "carry_on_non_negativity")  # explicitly add non-negativity
m.addConstr(large >= 0, "large_non_negativity")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of carry-on suitcases: {carry_on.x:.2f}")  # Format output for fractional suitcases
    print(f"Number of large suitcases: {large.x:.2f}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")


#  Add integrality constraints if only whole suitcases can be produced
# carry_on.vtype = gp.GRB.INTEGER
# large.vtype = gp.GRB.INTEGER
# m.optimize()
# if m.status == gp.GRB.OPTIMAL:
#     print("Integer Solution:")
#     print(f"Optimal profit: ${m.objVal:.2f}")
#     print(f"Number of carry-on suitcases: {carry_on.x}")
#     print(f"Number of large suitcases: {large.x}")
# elif m.status == gp.GRB.INFEASIBLE:
#     print("The integer model is infeasible.")
# else:
#     print(f"Integer optimization terminated with status {m.status}")

